<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 썸네일 크기 수정
$thumb_width = 300; // 가로
$thumb_height = 300; // 세로
?>

<div class="latest_wrap">
    <?php
    for ($i=0; $i<count($list); $i++) {
        $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

        if($thumb['src']) {
            $img = $thumb['src'];
        } else {
            $img = $latest_skin_url.'/img/noimg.png';
            $thumb['alt'] = '등록된 이미지가 없습니다.';
        }
        $img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
    ?>

    <div class="latest_item" onclick="location.href='<?php echo $list[$i]['href'] ?>';" style="cursor: pointer;">
        <div class="latest_info">
            <div class="latest_member_id">
                <?php echo $list[$i]['name'] ?>
            </div>
            <div class="latest_subject">
                <?php echo $list[$i]['subject'] ?>
            </div>
            <div class="latest_content">
                <?php echo cut_str(strip_tags($list[$i]['wr_content']), 80)?>
            </div>
        </div>
        <div class="latest_img">
            <?php echo $img_content; ?>
        </div>
    </div>

    <?php } ?>
    <?php if (count($list) == 0) { //게시물이 없을 때 ?>
    <div class="latest_item">
        <div class="latest_content">
            등록된 게시물이 없습니다.
        </div>
    </div>
    <?php } ?>

</div>

<style>
/* 전체적인 피드 구성 */
.latest_wrap {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 20px;
}

/* 각 게시물 스타일 */
.latest_item {
    display: flex;
    flex-direction: row;
    align-items: stretch;
    background-color: #fff;
    border-radius: 10px;
    overflow: hidden;
    width: 100%;
    max-width: 800px; /* 최대 너비 설정 */
}

/* 텍스트 정보 스타일 */
.latest_info {
    padding: 10px;
    flex: 1; /* 나머지 공간을 차지하도록 설정 */
}

/* 썸네일 이미지 스타일 */
.latest_img {
    flex: 0 0 auto; /* 썸네일 크기를 고정 */
    width: <?php echo $thumb_width; ?>px; /* 고정 너비 */
    height: <?php echo $thumb_height; ?>px; /* 고정 높이 */
}

.latest_img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 0 10px 10px 0; /* 이미지의 모서리에만 둥글게 */
}

/* 텍스트 스타일 */
.latest_member_id, .latest_subject {
    font-family: 'Montserrat', sans-serif;
    font-weight: bold;
    margin-bottom: 5px;
}

.latest_content {
    font-family: 'Roboto', sans-serif;
    font-size: 14px;
    color: #3a3a3a;
}

/* 반응형 디자인 */
@media (max-width: 768px) {
    .latest_item {
        flex-direction: column; /* 모바일에서는 세로로 배치 */
        align-items: center;
    }
    .latest_img {
        width: 100%;
        height: auto; /* 모바일에서는 높이를 자동 조절 */
    }
    .latest_img img {
        height: auto; /* 이미지 높이 자동 조절 */
    }
}
</style>